//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	HILDA setup restricted
// Objective: 	Importing the data from each wave of HILDA into a combined
//				dataset.
//
// Created: 	09/04/2021
// Modified: 	16/11/2021
//==============================================================================

* The following is a program written by Associate Professor Francisco Perales Perez (University of Queensland) for the purpose of creating a longitudinal file in the long format. It extracts variables from the combined files, master file and longitudinal weights file.

* You can install the .ado file by either entering "help hildasetup" into the command window and following the prompts, or, if you have administrator access, you can copy the .ado file downloaded from https://melbourneinstitute.unimelb.edu.au/hilda/for-data-users/program-library into "C:\Program Files\Stata16\ado\plus.

* Alternatively, you can copy-paste the text from the .ado file into a .do file and run it prior to attempting to use the hildasetup function.

clear all

**************************
*** Importing the data ***
**************************

set maxvar 12000
* The default maxvar is insufficient to import the full HILDA dataset.

hildasetup, data("XXXX") file(HILDA_restricted) var(hw* pw* tif* oif* fis* fatr* dodtyp* rt* hsdebti hsmguse hslnoth hsfrea hsfa hstenr hstenur hsnhown hsnhp hsoid* hsyr hsprice hsvalue hhpxid hhadult hhfam hhrih hhfty hhtype hhrhid hhpers hhstate hhsec10 hhtup hgxid* hgage hgsex hgint psyodf psyodm hhwt* hhrhid hs* chc* chh* chu* cpc* cph* cpu* cnpc* cnph* cnpu* cnsc* cnsh* cnsu* led* hercap* hencap* bncap* bifip bifin bifdiva bifiga bnfisi bnfnisi bnfobi bnfrpi bnffpi bnfapti hg* psmagd psfagd psb psbkm psfkm psmkm bskm*  ncdst* wave xwaveid opown* oirnti* wsfe* fl* sa* ncag* ncsex* ncrfs* ncafs* ncexs* rcag* rcsex* rcdst* rcafs* ncudr17 scmatch gh1 gh2 gcec gcecf ccactci rcstepg oiinti oidvryi fainvcv faoficv oaval tchave tchad fmhsib bsn bsany fmfhlq fmmhlq edhigh1 fmagelh fmageln mrcms mrcurr lnwte hh0_4 hh5_9 hh10_14 hhfxid hhmxid xhh*) rel(19) master(sex yob yodeath aadeath isdeath) lwfile(wleb__r wlej__r) unconf	// set data folder at XXXX
* To run this program you are required to locate your extracted HILDA files (the combined, master and longitudinal weights files should all be in the same place), choose your save destination and select the variables you want to keep from each of the files.
 
* Add "lw(wl*)" to the end if longitudinal weights are required.

*************************
*** Cleaning the data ***
*************************

*clean the household grid
foreach i of num 1/20{
    	
replace hgxid`i' ="." if hgxid`i' == "-------"
	
}

* destringing ID variables
destring hgxid*, replace
destring hhrhid, replace
destring xwaveid, replace

save HILDA_restricted, replace	// saving the dataset